
--A.1
type Valor =Int
type NombreVar = String
type Entorno= [(NombreVar, Valor)]


ent1 :: Entorno
ent1 =[("cont",10),("b",15),("fact",60)]

buscar:: Entorno->NombreVar->Valor
buscar [] y = error (y ++ " no definida")
buscar ((z,w):xs) y 
                |z==y        = w
                |otherwise   = buscar xs y

--A2

asignar :: Entorno->NombreVar->Valor->Entorno
asignar [] x y = [(x,y)]
asignar ((z,w):zs) x y 
              |x==z 	 = (z,y):zs
              |otherwise = (z,w):asignar zs x y 


--B
infixl 7 :*
infix 7 :/
infixl 6 :+,:-

data Expr= Const Valor | Var NombreVar 
           | Expr :+ Expr  | Expr :- Expr
           | Expr :* Expr  | Expr :/ Expr

expr1 :: Expr
expr1 = Const 3 :* Var "cont" :+ Var "b" 

evalExpr:: Entorno->Expr->Valor
evalExpr xs (Const y) = y
evalExpr xs (Var y) = buscar xs y
evalExpr xs (a :+ b) = (evalExpr xs a) + (evalExpr xs b)
evalExpr xs (a :- b) = (evalExpr xs a) - (evalExpr xs b)
evalExpr xs (a :* b) = (evalExpr xs a) * (evalExpr xs b)
evalExpr xs (a :/ b) = (evalExpr xs a) `div` (evalExpr xs b)


--C

infix 5 :=
{-
data Sentencia = NombreVar := Expr |Inc NombreVar
-}
type Programa = [Sentencia]

prog1 = [ "a" := Const 10,
          "b" := Const 20,
          "c" := Const 5 :* Var "a" :+ Var "b",
          Inc "c"]


--C.1
{-
runSent :: Entorno->Sentencia->Entorno
runSent xs (y := sen) = asignar xs y (evalExpr xs sen)
runSent xs (Inc y) = asignar xs y ((buscar xs y)+ 1)
-} 

--C2
runProg :: Programa->Entorno
runProg  = runProg' []
runProg' e = foldl runSent e

--D

data Sentencia = NombreVar := Expr |Inc NombreVar
                 | For (NombreVar,Expr,Expr) [Sentencia]
prog2 = ["sum" := Const 0,
         For("i",Const 1,Const 5)
		[
			"sum" := Var "sum" :+ Var "i"
		]
	]

-- Este For a su salida deja la variable al ultimo valor
-- Adems evalua los limites una sola vez
runSent :: Entorno->Sentencia->Entorno
runSent xs (y := sen) = asignar xs y (evalExpr xs sen)
runSent xs (Inc y) = asignar xs y ((buscar xs y)+ 1)
runSent xs (For (v,i,f) ss) = foldl (\e x -> runProg' (asignar e v x) ss) xs [vi..vf] 
			where vi = evalExpr xs i
			      vf = evalExpr xs f


